import java.math.BigDecimal;

class ForkJoinTest {
	private static BigDecimal multiplyIt(int start, int end) {
		BigDecimal factorial = BigDecimal.valueOf(start);
		for (int i = start + 1; i <= end; i++)
			factorial = factorial.multiply(BigDecimal.valueOf(i));
		return factorial;
	}

	public static void main(String[] args) {
		int argument = 50_000;
		int schwelle = 100;
		long zeit;
		BigDecimal ergebnis;

		// Einmalige Berechnung der Fakultät per Fork-Join - Framework mit automatischer Schwelle
//		zeit = System.currentTimeMillis();
//		ergebnis = FactorialForkJoin.factorial(argument);
//		System.out.printf("\nLaufzeit mit Fork-Join in Millisekunden:%7d Ergebnis: %e)",
//				(System.currentTimeMillis()-zeit), ergebnis);

		// 5-malige Berechnung der Fakultät per Fork-Join - Framework mit manueller Schwelle
		for (int i = 0; i < 5; i++) {
			zeit = System.currentTimeMillis();
			ergebnis = FactorialForkJoin.factorial(argument, schwelle);
			System.out.printf("\nFork-Join - Laufzeit in MS (Schwelle 100):%7d (Ergebnis: %e)", (System.currentTimeMillis()-zeit), ergebnis);
		}

		//  5-malige Berechnung der Fakultät per Fork-Join - Framework (automatische Schwellenberechnung)
		System.out.println("\n");
		for (int i = 0; i < 5; i++) {
			zeit = System.currentTimeMillis();
			ergebnis = FactorialForkJoin.factorial(argument);
			System.out.printf("\nFork-Join - Laufzeit in Millisekunden:    %7d (Ergebnis: %e)", (System.currentTimeMillis()-zeit), ergebnis);
		}

		//  5-malige Berechnung der Fakultät durch den main-Thread
		System.out.println("\n");
		for (int i = 0; i < 5; i++) {
			zeit = System.currentTimeMillis();
			ergebnis = multiplyIt(1, argument);
			System.out.printf("\nSingle-Thread - Laufzeit in Millisekunden:%7d (Ergebnis: %e)", (System.currentTimeMillis()-zeit), ergebnis);
		}

		//  5-malige Berechnung der Fakultät per Fork-Join (Single-Thread; Aufgabenaufteilung wird durch den Schwellenwert verhindert)
		System.out.println("\n");
		for (int i = 0; i < 5; i++) {
			zeit = System.currentTimeMillis();
			ergebnis = FactorialForkJoin.factorial(argument, 100_000);
			System.out.printf("\nFork-Join-ST - Laufzeit in Millisekunden: %7d (Ergebnis: %e)", (System.currentTimeMillis()-zeit), ergebnis);
		}
	}
}
